//
//  B5CustomIconAttributes.h
//  ApplicationFrameworks
//
//  Created by Nathan Van Fleet on 2015-08-13.
//
//

#import <Foundation/Foundation.h>

@class B5MutableCustomIconAttributes;
@class OPSymmetricKey;
@class OPAESKey;
@class B5Profile;

@interface B5CustomIconAttributes : NSObject
@property (readonly, nonatomic) NSString *fileId;
@property (readonly, nonatomic) OPSymmetricKey *key;
@property (readonly, nonatomic) NSData *nonce;
@property (readonly, nonatomic) OPSymmetricKey *signingKey;

- (B5MutableCustomIconAttributes *)mutableCopy;
- (B5CustomIconAttributes *)copy;

+ (B5CustomIconAttributes*)attributesFromJSON:(NSDictionary *)json;
- (NSDictionary *)JSONValue;

- (BOOL)hasFileReferenceSigningKey;

// Encrypted Attributes
- (NSData *)encryptedAttributesWithProfile:(B5Profile *)profile;
+ (B5CustomIconAttributes *)attributesFromEncryptedData:(NSData *)data profile:(B5Profile *)profile;

@end

@interface B5MutableCustomIconAttributes : B5CustomIconAttributes
@property (readwrite, nonatomic) NSString *fileId;
@property (readwrite, nonatomic) OPSymmetricKey *key;
@property (readwrite, nonatomic) NSData *nonce;
@property (readwrite, nonatomic) OPSymmetricKey *signingKey;
@end
